﻿#region Using Statements

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;

using HIPS.PcehrDataStore.Schemas.Enumerators;

using HIPS.Web.ModelInterface;
using HIPS.Web.ModelInterface.Common;
using HIPS.Web.ModelInterface.PcehrView;
using HIPS.Web.Model.Common;

using HIPS.Web.Data.Hips;
using HIPS.Web.Data.Hips.PcehrView;
using HIPS.Web.Data.WebsiteDb;

using HIPS.Web.Components.Cache;

using HIPS.Web.UI.Controllers;
using HIPS.Web.UI.Helpers;
using HIPS.Web.UI.ViewModels.PcehrView;

#endregion

namespace HIPS.Web.UI.Filters
{

    /// <summary>
    /// Provides an action filter attribute that supports checking access to the PCEHR.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="09 January 2014">Initial version.</change>
    /// </history>
    public class PcehrAccessAttribute : Attribute
    {

        #region Properties

        /// <summary>
        /// Gets or sets a Boolean value that indicates whether to automatically attempt to gain access if required.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="10 January 2014">Initial version.</change>
        /// </history>
        public bool AutoAccess { get; set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="autoAccess">A Boolean value that indicates whether to automatically attempt to gain access if required. Defaults to true.</param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="21 November 2013">Initial version.</change>
        /// </history>
        public PcehrAccessAttribute(bool autoAccess = true)
        {
            this.AutoAccess = autoAccess;
        }

        #endregion

    }

}